<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:nunit2report="urn:my-scripts">
	
	<xsl:output method="html" indent="yes"/>

	<xsl:template match="/">
		<HTML>
			<HEAD>
			<style type="text/css">
				body {
					font:normal 68% verdana,arial,helvetica;
					color:#000000;
				}

				span.covered {
					background: #00df00; 
					border:#9c9c9c 1px solid;
				}
				span.uncovered {
					background: #df0000; 
					border-top:#9c9c9c 1px solid;
					border-bottom:#9c9c9c 1px solid;
					border-right:#9c9c9c 1px solid;
					}
				span.ignored {
					background: #ffff00;
					border-top:#9c9c9c 1px solid;
					border-bottom:#9c9c9c 1px solid;
					border-right:#9c9c9c 1px solid;
				}

				td {
					FONT-SIZE: 68%;
					BORDER-BOTTOM: #dcdcdc 1px solid; 
					BORDER-RIGHT: #dcdcdc 1px solid;
				}
				p {
					line-height:1.5em;
					margin-top:0.5em; 
					margin-bottom:1.0em;
				}
				h1 {
					MARGIN: 0px 0px 5px; 
					FONT: 165% verdana,arial,helvetica;
				}
				h2 {
					MARGIN-TOP: 1em; 
					MARGIN-BOTTOM: 0.5em; 
					FONT: bold 125% verdana,arial,helvetica;
				}
				h3 {
					MARGIN-BOTTOM: 0.5em; 
					FONT: bold 115% verdana,arial,helvetica;
				}
				h4 {
					MARGIN-BOTTOM: 0.5em; 
					FONT: bold 100% verdana,arial,helvetica;
				}
				h5 {
					MARGIN-BOTTOM: 0.5em; 
					FONT: bold 100% verdana,arial,helvetica
				}
				h6 {
					MARGIN-BOTTOM: 0.5em; 
					FONT: bold 100% verdana,arial,helvetica
				}	
				.Error {
					font-weight:bold; 
				}
				.Failure {
					font-weight:bold; 
					color:red;
				}
				.Ignored {
					font-weight:bold; 
				}
				.FailureDetail {
					font-size: -1;
					padding-left: 2.0em;
					background:#cdcdcd;
				}
				.Pass {
					padding-left:2px;
				}
				.TableHeader {
					background: #efefef;
					color: #000;
					font-weight: bold;
					horizontal-align: center;
				}
				a:visited {
					color: #0000ff;
				}
				a {
					color: #0000ff;
				}
				a:active {
					color: #800000;
				}
				a.summarie {
					color:#000;
					text-decoration: none;
				}
				a.summarie:active {
					color:#000;
					text-decoration: none;
				}
				a.summarie:visited {
					color:#000;
					text-decoration: none;
				}
				.description {
					margin-top:1px;
					padding:3px;
					background-color:#dcdcdc;
					color:#000;
					font-weight:normal;
				}
				.method{
					color:#000;
					font-weight:normal;
					padding-left:5px;
				}
				a.method{
					text-decoration: none;
					color:#000;
					font-weight:normal;
					padding-left:5px;
				}
				a.Failure {
					font-weight:bold; 
					color:red;
					text-decoration: none;
				}
				a.Failure:visited {
					font-weight:bold; 
					color:red;
					text-decoration: none;
				}
				a.Failure:active {
					font-weight:bold; 
					color:red;
					text-decoration: none;
				}
				a.error {
					font-weight:bold; 
					color:red;
				}
				a.error:visited {
					font-weight:bold; 
					color:red;
				}
				a.error:active {
					font-weight:bold; 
					color:red;
					/*text-decoration: none;
					padding-left:5px;*/
				}
				a.ignored {
					font-weight:bold; 
					text-decoration: none;
					padding-left:5px;
				}
				a.ignored:visited {
					font-weight:bold; 
					text-decoration: none;
					padding-left:5px;
				}
				a.ignored:active {
					font-weight:bold; 
					text-decoration: none;
					padding-left:5px;
				}
		</style>
		<script language="JavaScript"><![CDATA[   
		function Toggle(id) {
		var element = document.getElementById(id);

			if ( element.style.display == "none" )
				element.style.display = "block";
			else 
				element.style.display = "none";
		}

		function ToggleImage(id) {
		var element = document.getElementById(id);

			if ( element.innerText   == "-" )
				element.innerText   = "+";
			else 
				element.innerText = "-";
		}
		]]></script>
			</HEAD>
			<body text="#000000" bgColor="#ffffff">
				<xsl:variable name="utrDoc" select="document('VBECS.UnitTest.xml')" />

				<h1>VBECS Automated Build Report</h1>
				<table width="95%" border="0" style="border-collapse: collapse; border-width: 0">
					<tr>
						<td align="left" style="border: 0;">
							Generated with XSL stylesheet at: <xsl:value-of select="$utrDoc/test-results/@date"/> - <xsl:value-of select="concat($utrDoc/test-results/@time,' ')"/>
						</td>
						<td align="right" style="border: 0;">
							Based on&#160;<a target="_blank" href="http://sourceforge.net/projects/nunit2report/">NUnit2Report</a>&#160;reports
						</td>
					</tr>
				</table>
				<hr size="1" width="95%" align="left"/>
		
				<h2>Overview</h2>
				The VBECS_@VERSION@ automated build process was completed. Please review unit test report summary below.
				<br></br> <br></br>
				<!-- Detailed unit test and FxCop violation reports as well as recent build logs may be found at <a href="http://@UNITTEST_SERVER@/@VERSION@/UnitTestsReport/UnitTestsReportIndex.html">http://@UNITTEST_SERVER@/@VERSION@/UnitTestsReport/UnitTestsReportIndex.html</a>.  -->
				Detailed reports page can be found at <a href="http://@UNITTEST_SERVER@/@VERSION@/webfiles/index.html">http://@UNITTEST_SERVER@/@VERSION@/webfiles/index.html</a>.
				<br></br>
				The NAnt Automated Build Log file can be found at <a href="http://@UNITTEST_SERVER@/@VERSION@/NightlyBuild_OutputLog.txt">http://@UNITTEST_SERVER@/@VERSION@/NightlyBuild_OutputLog.txt</a>.
				<br></br>
				The NCover Coverage file can be found at <a href="http://@UNITTEST_SERVER@/@VERSION@/Coverage.xml">http://@UNITTEST_SERVER@/@VERSION@/Coverage.xml</a>.
				<br></br> <br></br>

				<h2>VBECS_@VERSION@ Unit Tests Summary</h2>
				<xsl:apply-templates select="$utrDoc//test-results" />

				<br>&#160;</br>
				<hr size="1" width="95%" align="left"/>
			</body>
		</HTML>
	</xsl:template>

	<xsl:template match="test-results">
		<xsl:call-template name="unitTestsSummary"/>
	</xsl:template>

	<!--
		format a number in to display its value in percent
		@param value the number to format
	-->
	<xsl:template name="display-time">
		<xsl:param name="value"/>
		<xsl:value-of select="format-number($value,'0.000')"/>
	</xsl:template>

	<!--
		format a number in to display its value in percent
		@param value the number to format
	-->
	<xsl:template name="display-percent">
		<xsl:param name="value"/>
		<xsl:value-of select="format-number($value,'0.00 %')"/>
	</xsl:template>

	<xsl:template name="unitTestsSummaryHeader">
		<tr valign="top" class="TableHeader">
			<td width="50px"><b>Tests</b></td>
			<td width="70px"><b>Failures</b></td>
			<td width="70px"><b>Ignores</b></td>
			<td colspan="2"><b>Success Rate</b></td>
			<td width="70px" nowrap="nowrap"><b>Time(s)</b></td>
		</tr>
	</xsl:template>

	<xsl:template name="unitTestsSummary">		
		<xsl:variable name="runCount" select="@total"/>
		<xsl:variable name="failureCount" select="@failures + @errors"/>
		<xsl:variable name="ignoreCount" select="@ignored"/>
		<xsl:variable name="total" select="$runCount + $ignoreCount"/>

		<xsl:variable name="timeCount" select="translate(test-suite/@time,',','.')"/>

		<xsl:variable name="successRate" select="($total - $failureCount) div $total"/>
		<table border="0" cellpadding="2" cellspacing="0" width="95%" style="border: #dcdcdc 1px solid;">
		<xsl:call-template name="unitTestsSummaryHeader"/>
		<tr valign="top">
			<xsl:attribute name="class">
    			<xsl:choose>
    			    <xsl:when test="$failureCount &gt; 0">Failure</xsl:when>
    				<xsl:when test="$ignoreCount &gt; 0">Ignore</xsl:when>
    				<xsl:otherwise>Pass</xsl:otherwise>
    			</xsl:choose>			
			</xsl:attribute>		
			<td><xsl:value-of select="$runCount"/></td>
			<td><xsl:value-of select="$failureCount"/></td>
			<td><xsl:value-of select="$ignoreCount"/></td>
			<td nowrap="nowrap" width="70px">
			    <xsl:call-template name="display-percent">
			        <xsl:with-param name="value" select="$successRate"/>
			    </xsl:call-template>
			</td>
			<td>
				<xsl:if test="round(($total - $ignoreCount - $failureCount) * 200 div $total )!=0">
					<span class="covered">
						<xsl:attribute name="style">width:<xsl:value-of select="round(($total - $ignoreCount - $failureCount) * 200 div $total )"/>px</xsl:attribute>
					</span>
				</xsl:if>
				<xsl:if test="round(($total - $ignoreCount) * 200 div $total )!=0">
				<span class="ignored">
					<xsl:attribute name="style">width:<xsl:value-of select="round($ignoreCount * 200 div $total )"/>px</xsl:attribute>
				</span>
				</xsl:if>
				<xsl:if test="round(($total - $failureCount) * 200 div $total )!=0">
					<span class="uncovered">
						<xsl:attribute name="style">width:<xsl:value-of select="round($failureCount * 200 div $total )"/>px</xsl:attribute>
					</span>
				</xsl:if>
			</td>
			<td>
			    <xsl:call-template name="display-time">
			        <xsl:with-param name="value" select="$timeCount"/>
			    </xsl:call-template>
			</td>
		</tr>
		</table>
		<div style="margin-top: 0.5em;">
			Note: <i>Ignores</i>&#160;are anticipated and checked for with assertions while&#160;<i>failures</i>&#160;are unanticipated.
		</div>
	</xsl:template>
</xsl:stylesheet>